define([
    'backbone',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/facility-caretype-selection/caretype-section-view',
],
function(
    Backbone,
    Layout,
    CareTypeSectionView
) {
    'use strict';
    describe('CareType Section View', function() {
        var view;
        var layout = new Layout();
        var typeOfCare1;
        var typeOfCare2;
        var typeOfCare3;
        var typeOfCare4;
        var typeOfCare5;
        var typeOfCare6;
        var typeOfCare7;
        var ccTypeOfCares;
        var model;
        layout.render();
        beforeEach(function() {
            spyOn(CareTypeSectionView.prototype, 'changeCareType').and.callThrough();
            spyOn(CareTypeSectionView.prototype, 'changeCareTypeContinue').and.callThrough();
            layout.render();
            model = new Backbone.Model({steps: [5]});
            typeOfCare1 = new Backbone.Model({
                'id': 'CCAUDHEAR',
                'name': 'Audiology (hearing aid support)',
                'details': 'This is an office visit for Veterans who already have a hearing aid and who need assistance with the device. This visit is for trouble shooting or adjusting your hearing aid for best performance. This may include technical adjustments, cleaning, and/or reprogramming for new listening situations and environments. This is not a visit to initially be evaluated for or to obtain a hearing aid.',
                'confirmation': 'This request is for hearing aid support only. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.',
            });
            typeOfCare2 = new Backbone.Model({
                'id': 'CCAUDRTNE',
                'name': 'Audiology (routine hearing exam)',
                'details': 'This includes an office visit for a hearing exam and evaluation using non-invasive tests to check your hearing and inner ear health. The exam may lead to prevention and treatment recommendations, a request for further consultation, and/or a recommendation for hearing aids. A routine exam is not for any new or sudden changes with your hearing or ears.',
                'confirmation': 'This request is for routine hearing exam only. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.',
            });
            typeOfCare3 = new Backbone.Model({
                'id': 'CCOPT',
                'name': 'Optometry (routine eye exam)',
                'details': 'This includes an office visit for an eye exam and vision evaluation, which may include dilating your eyes. The exam may lead to prevention and treatment recommendations, a request for further consultation, and/or a prescription for eye glasses or contact lenses. A routine exam is not for any new or sudden changes with your vision or eyes.',
                'confirmation': 'This request currently only supports routine eye exams. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.',
            });
            typeOfCare4 = new Backbone.Model({
                'id': 'CCPOD',
                'confirmation': 'This request currently only supports routine podiatry exams. If you have other needs, please contact your Primary Care Provider to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.',
                'details': 'This includes an office visit for an exam of the foot, ankle and related structures of the leg. The exam may lead to diagnosis and treatment to include common conditions like callous, bunions, and other conditions requiring in office treatment, orthotics, and possibly the need for surgery. If you are experiencing any acute conditions or sudden onset of pain, break in the skin with possible infection, please contact your local VAMC.',
                'name': 'Podiatry (routine exam)',
            });
            typeOfCare5 = new Backbone.Model({
                'id': 'CCPCPRVDR',
                'confirmation': 'This request currently only supports the finding of a Primary Care Provider. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.',
                'details': "If approved, you'll be assigned to a primary care provider in the community to whom we will send the approved referral. Once assigned, you will be provided information and will need to contact the provider’s office directly for preventive and other health care needs for the duration of the approved referral.",
                'name': 'Primary Care (find a provider)',
            });
            typeOfCare6 = new Backbone.Model({
                'id': 'CCNUTRN',
                'confirmation': 'This includes office visit(s) which will provide education on a healthy lifestyle including food and drink choices, reading food labels, and limits on nutritional intake. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.',
                'details': 'This includes office visit(s) which will provide education on a healthy lifestyle including food and drink choices, reading food labels, and limits on nutritional intake.',
                'name': 'Nutrition (routine exam)',
            });
            typeOfCare7 = new Backbone.Model({
                'id': 'CCPRMYRTNE',
                'confirmation': 'This includes office visit(s) with a Primary Care Provider, focused on routine/acute patient complaints, wellness and disease prevention resulting in improved veteran health. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are not distance eligible and do not have a Primary Care Provider, you can use this app to request a VA Appointment with a Primary Care Provider.',
                'details': 'This includes office visit(s) with a Primary Care Provider, focused on routine/acute patient complaints, wellness and disease prevention resulting in improved veteran health.',
                'name': 'Primary Care (routine exam)',
            });
            ccTypeOfCares = new Backbone.Collection([
                typeOfCare1,
                typeOfCare2,
                typeOfCare3,
                typeOfCare4,
                typeOfCare5,
                typeOfCare6,
                typeOfCare7,
            ]);
            view = new CareTypeSectionView({
                ccTypeOfCares: ccTypeOfCares,
                model: model,
            });
            layout.showChildView('content', view);
        });

        afterEach(function () {
            layout.getRegion('content').empty();
        });

        describe('when the caretype model changes', function() {
            it('has a caretype changed', function() {
                view.model.set('careType', 'CCNUTRN');
                expect(view.model.get('careTypeContinue')).toEqual('');
                expect(view.model.get('careTypeName')).toEqual('Nutrition (routine exam)');
                expect(view.model.get('careTypeDetails')).toEqual('This includes office visit(s) which will provide education on a healthy lifestyle including food and drink choices, reading food labels, and limits on nutritional intake.');
            });
            it('will not update the model when an unknown caretype is selected', function() {
                view.model.set('careType', 'CCTACOS');
                expect(view.model.get('careTypeContinue')).toEqual('');
                expect(view.model.has('careTypeName')).toBe(false);
                expect(view.model.has('careTypeDetails')).toBe(false);
            });
        });

        describe('when the caretype is selected and you decide whether or not to continue', function() {
            it('will set  confirmation message in model when no is selected to continue', function() {
                view.model.set('careType', 'CCPRMYRTNE');
                view.model.set('careTypeContinue', 'no');
                expect(view.model.get('careTypeConfirmation')).toEqual('This includes office visit(s) with a Primary Care Provider, focused on routine/acute patient complaints, wellness and disease prevention resulting in improved veteran health. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are not distance eligible and do not have a Primary Care Provider, you can use this app to request a VA Appointment with a Primary Care Provider.');
            });
            it('will not confirmation message in model when yes is selected to continue', function() {
                view.model.set('careType', 'CCPRMYRTNE');
                view.model.set('careTypeContinue', 'yes');
                expect(view.model.has('careTypeConfirmation')).toBe(false);
            });
        });
    });
});
